#ifndef KMODULE_LIST
#define KMODULE_LIST

#include <stdbool.h>
#include <libkmod.h>

#include "global_types.h"

typedef struct kmodule_t kmodule_t;

typedef struct kmodule_list_entry_t kmodule_list_entry_t;

typedef void kmodule_list_t;

typedef void * kmodule_list_iterator_t;

kmodule_list_t *kmodule_list_create(void);

void kmodule_list_free(kmodule_list_t *list);

bool kmodule_list_is_empty(kmodule_list_t *list);

error_code_t kmodule_list_queue_module(kmodule_list_t *list, kmodule_t *kmodule, 
		kmodule_list_entry_t **list_entry_ptr);

kmodule_t *kmodule_list_dequeue_module(kmodule_list_t *list);

kmodule_t *kmodule_list_first_entry(kmodule_list_t *list, kmodule_list_iterator_t *itr);

kmodule_t  *kmodule_list_next_entry(kmodule_list_iterator_t *itr);

void kmodule_list_remove_from_list(kmodule_list_entry_t *list_entry_ptr);

kmodule_t *kmodule_list_get_entry(kmodule_list_t *list, const struct kmod_module *kmod);

#endif
